/*
JDB_log

Version 1 - Version GNU/Linux.
[Copyright 2022,2023 Gérome CHAVANAS] (gerome@chavanas.fr)
[Copyright 2023 F4LCF Gérome] (contact@f4lcf.fr)

Logiciel Libre sous Licence GPL v.3 (Voir en bas de fichier).
Pouquoi ne pas le compiler avec GNU GCC ;-) ?
Logiciel en mode Console uniquement.
*/


#include <stdio.h>
#include <stdlib.h>


int main(int argc, char const *argv[])
{
	int boucle_principale;
	FILE *journal_indicatif;

	do
	{

	//Accueil et menu principal.

	int choix_debut;

	system("cls");

	printf("##################################################\n");
	printf("##                     JDB_log                  ##\n");
	printf("## -------------------------------------------- ##\n");
	printf("##  Un programme simple pour consigner ses QSO. ##\n");
	printf("## -------------------------------------------- ## \n");
	printf("##  Version 1  (C)2023  F4LCF / Gerome CHAVANAS ##\n");
	printf("##################################################\n\n");

	printf("1 >> Saisir un nouveau QSO.\n");
	/*printf("2 >> Recherche par Indicatif [NON FONCTIONNEL]\n");
	printf("3 >> Modification d'un QSO [NON FONCTIONNEL]\n");*/
	printf("4 >> Creation, ou remise a zero, du Journal de Bord\n\n\n");
	printf("0 >> Quitter\n\n\n");
	printf("Votre choix : ");
	scanf("%d" , &choix_debut);


		if (choix_debut == 1)
		{
			int boucle_qso;
			int validation_saisie_qso;

			char date[12];
			int heure_d = 0;
			int heure_f = 0;
			char indicatif_correspondant[12];

			char prenom_correspondant[16];

			char suffixe[4];
			long frequence_emission = 0;
			char classe_emission[4];
			char lieu_emission[256];


			do
			{
				// Vérification de la présence d'un journal déjà crée.
				FILE *journal_indicatif = fopen("journal_de_bord.txt" , "r");

				if (journal_indicatif == NULL) // Si le journal n'existe pas.
					{
						printf("\n\n\nVotre journal n'existe pas !!!\n\n\nVous devez prealablement creer votre journal.");
						break;
					}

				if (journal_indicatif != NULL)// Le journal existe.
					{

					do
						{
							// Saisie des éléments du QSO. [09/2023 >> Le minimum légal].

							system("cls");

							printf("Saisie d'un nouveau QSO\n\n");
							printf("Date du QSO (JJ-MM-AAAA): ");
							scanf("%s" , date);
							printf("Debut du QSO, en Heure Universelle > (Format hhmm) : " );
							scanf("%d" , &heure_d);
							printf("Fin du QSO, en Heure Universelle  >  (Format hhmm) : " );
							scanf("%d" , &heure_f);
							printf("Indicatif du correspondant : ");
							scanf("%s" , indicatif_correspondant);

							printf("Prenom du correspondant (Sans accent(s)) : ");
							scanf("%s" , prenom_correspondant);

							printf("Frequence d'emission (en kHz) : ");
							scanf("%ld" , &frequence_emission);
							printf("Classe d'emission : ");
							scanf("%s" , classe_emission);
							printf("Lieu d'emission (Sans accent(s) sans espaces ou relier avec '_'): ");
							scanf("%s" , lieu_emission);

							system("cls");

							printf("Resume de la saisie : \n");
							printf("-------------------\n");
							printf("QSO du %s\n", date);
							printf("De %04d T.U à" , heure_d);
							printf(" %04d T.U\n" , heure_f);
							printf("Avec %s  " , indicatif_correspondant);
							printf(" %s  " , prenom_correspondant);
							printf("sur %ld kHz ," , frequence_emission );
							printf("en %s .\n" , classe_emission);
							printf("Depuis %s ." , lieu_emission);
							printf("\n\n\n");

							printf("Validez vous la saisie ? ( 1 Oui / 0 Non ) : ");
							scanf("%d" , &validation_saisie_qso);

						} while (validation_saisie_qso != 1);


					// Inscription du QSO dans le fichier .TXT

					FILE *journal_indicatif = fopen("journal_de_bord.txt" , "a");

					fprintf(journal_indicatif, "%-10s   %4d    %-4d      %-9s   %-15s %6ld kHz   %-3s    %-25s\n" 	, date , heure_d , heure_f ,
					indicatif_correspondant, prenom_correspondant, frequence_emission , classe_emission , lieu_emission);
					fclose(journal_indicatif);

					printf("Votre QSO est valide , et est inscrit dans le Journal de Bord\n\n\n");

					printf("Voulez-vous saisir un nouveau QSO ? (1 oui / 0 non)\n");
					scanf("%d" , &boucle_qso);

					}

			}while (boucle_qso != 0);
		}

		if (choix_debut == 4)
		{
			int boucle_indicatif;

				system("cls");
				printf("!!!! ATTENTION !!!!   ATTENTION !!!!   ATTENTION !!!! ATTENTION !!!! ATTENTION !!!!\n");
				printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
				printf("Verifiez dans le dossier du programme l'existance d'un fichier ' journal_de_bord.txt '.\n");
				printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n");
				printf("Si un journal existe deja, son entete, avec la date de debut et votre indicatif, sera remplace.\n\n");
				printf("Si vous souhaitez creer un nouveau Journal de Bord, vous pouvez renommer le fichier, cela le sauvegardera.\n\n");
				printf("Vous pourrez ensuite creer votre nouveau Journal de Bord\n\n");
				printf("Taper 1 pour continuer et creer un Journal de Bord.\n\n");
				printf("Taper 0 pour sortir et verifier la presence d'un Journal de Bord. (Ou Archiver le precedent)\n\n");
				printf("Ensuite, redemarrer de nouveau JDB_Log .\n\n");
				printf("Votre Choix : ");
				scanf("%d" , &boucle_indicatif);

				if (boucle_indicatif == 0)
				{
					break;
				}


			do
			{
				// Création du Journal de Bord [sans création du nom du dossier personnel]

				char indicatif_personnel[12];
				char date_debut_journal[12];
				int validation_saisie_journal;

				system("cls");
				printf("Nous allons preparer le Journal de Bord\n\n");
				printf("Quels est votre indicatif ? : ");
				scanf("%s" , indicatif_personnel);
				printf("A quelle date creez vous ce journal ? (JJ-MM-AAAA) : ");
				scanf("%s" , date_debut_journal);

				system("cls");

				printf("Votre Indicatif est : %s\n", indicatif_personnel );
				printf("Vous creez ce journal le %s : \n\n" , date_debut_journal );

				printf("1 pour valider / 0 pour refaire la saisie : ");
				scanf("%d", &validation_saisie_journal );

					if (validation_saisie_journal == 1)
					{

					system("echo >> journal_de_bord.txt");

					FILE* journal_indicatif = fopen("journal_de_bord.txt" , "r+");

					if (journal_indicatif == NULL)
						exit(1);

					fprintf(journal_indicatif, "------------------------------------------------------------------------------------------------\n");
					fprintf(journal_indicatif, "Journal de Bord de : %-12s .   Date de debut du Journal : %-12s .\n"
					, indicatif_personnel , date_debut_journal );
					fprintf(journal_indicatif, "En Heure Universelle (UTC)\n" );
					fprintf(journal_indicatif, "------------------------------------------------------------------------------------------------\n");
					fprintf(journal_indicatif, "Date      ;  Debut;  Fin  ;    Indicatif;  Prenom        ; Frequence;   Mode;  Lieu d'emission; \n");
					fprintf(journal_indicatif, "------------------------------------------------------------------------------------------------\n");
					fclose(journal_indicatif);

					printf("Votre Journal de Bord a ete cree avec succes.\n");
					printf("Il sera visible dans le dossier du programme sous le nom : 'journal_de_bord.txt' .\n");
					break;
					}

			} while (boucle_indicatif == 0);
		}

		if (choix_debut == 0)
		{
			exit(0);
		}



	printf("\n\nTaper '0' pour retourner au Menu Principal.  ");
	scanf("%d" , &boucle_principale);

	} while (boucle_principale == 0);


	return 0;
}


/*
This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License,
 or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program.
If not, see <https://www.gnu.org/licenses/>. 3
*/

